
var choices = ['A', 'B'];
var fonts = [ $('.A').css("font-family"), $('.B').css("font-family")]

$(document).ready(function() {

  function make_active() { 
    if ($('#next_j').prop('disabled') == true) {
      $('#next_j').prop('disabled', false).css({'visibility' : 'visible', 'color' : 'black'});
    }
  };

  $("input:radio[name=choose]").click(function() {
      make_active();
  });

  $('body').keydown(function (event) {
    if (event.keyCode == 37 || event.keyCode == 39) {
    event.preventDefault(); 
    }
  });

  $('body').keyup(function (event) {
  
    switch ( event.keyCode ) {
      case 37: 
        make_active();
        $("#left").prop("checked", true);
        break;
      case 39: 
        make_active();
        $("#right").prop("checked", true);
        break;
      case 13:
        $('#next_j').click();
        break;
    };


  });

  $('#the_form').submit(function(e) {
      $.ajax({
          type: 'POST',
          url: '/study/' + url_part.exp + '/' + url_part.para + '/tryajax',
          data: JSON.stringify({
            wordLeft: $('.A').html(),
            wordRight: $('.B').html(),
            }),
          contentType: "application/json",
          dataType: 'json',
          success: update_the_task,
          error: function(jqXHR, textStatus, errorThrown) {
             console.log(textStatus, errorThrown);
        }
      });
      e.preventDefault();
  });
});


function update_the_task (response) {
 
    $('.A').html(response['A']);
    $('.B').html(response['B']);

    choice = (Math.round(Math.random()));
    base = choices[choice];
    changing = choices[Math.abs(choice-1)];

    $('.' + base).css("font-family", fonts[0]); 
    $('.' + changing).css("font-family", fonts[1]); 

    $("input:radio[name=choose]").prop('checked', false);
    $("#next_j").prop("disabled", true).css({"left" : "45%", "color" : "#efefef"});
      
};
